/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import committee.nova.mods.avaritia.Static;
import committee.nova.mods.avaritia.api.client.model.PerspectiveModelState;
import committee.nova.mods.avaritia.api.client.model.bakedmodels.WrappedItemModel;
import committee.nova.mods.avaritia.api.client.render.item.IItemRenderer;
import committee.nova.mods.avaritia.client.shader.AvaritiaShaders;
import committee.nova.mods.avaritia.common.item.MatterClusterItem;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.util.client.TransformUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CosmicBakeModel
extends WrappedItemModel
implements IItemRenderer {
    private final List<ResourceLocation> maskSprite;

    public CosmicBakeModel(BakedModel wrapped, List<ResourceLocation> maskSprite) {
        super(wrapped);
        this.maskSprite = maskSprite;
    }

    @Override
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, PoseStack pStack, MultiBufferSource source, int light, int overlay) {
        if (stack.m_41720_() == ModItems.infinity_sword.get()) {
            this.parentState = TransformUtils.DEFAULT_TOOL;
        }
        if (stack.m_41720_() == ModItems.infinity_bow.get()) {
            this.parentState = TransformUtils.DEFAULT_BOW;
        }
        if (stack.m_41720_() != ModItems.infinity_bow.get() && stack.m_41720_() != ModItems.infinity_sword.get()) {
            this.parentState = TransformUtils.DEFAULT_ITEM;
        }
        this.renderWrapped(stack, pStack, source, light, overlay, true);
        if (source instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bs = (MultiBufferSource.BufferSource)source;
            bs.m_109911_();
        }
        Minecraft mc = Minecraft.m_91087_();
        float yaw = 0.0f;
        float pitch = 0.0f;
        float scale = 1.0f;
        if (AvaritiaShaders.inventoryRender || transformType == ItemDisplayContext.GUI) {
            scale = 100.0f;
        } else {
            yaw = (float)((double)(mc.f_91074_.m_146908_() * 2.0f) * Math.PI / 360.0);
            pitch = -((float)((double)(mc.f_91074_.m_146909_() * 2.0f) * Math.PI / 360.0));
        }
        AvaritiaShaders.cosmicTime.m_5985_((float)(System.currentTimeMillis() - (long)AvaritiaShaders.renderTime) / 2000.0f);
        AvaritiaShaders.cosmicYaw.m_5985_(yaw);
        AvaritiaShaders.cosmicPitch.m_5985_(pitch);
        AvaritiaShaders.cosmicExternalScale.m_5985_(scale);
        if (stack.m_41720_() == ModItems.matter_cluster.get()) {
            AvaritiaShaders.cosmicOpacity.m_5985_((float)MatterClusterItem.getClusterSize(stack) / (float)MatterClusterItem.CAPACITY);
        } else {
            AvaritiaShaders.cosmicOpacity.m_5985_(1.0f);
        }
        for (int i = 0; i < 10; ++i) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(Static.rl("misc/cosmic_" + i));
            AvaritiaShaders.COSMIC_UVS[i * 4] = sprite.m_118409_();
            AvaritiaShaders.COSMIC_UVS[i * 4 + 1] = sprite.m_118411_();
            AvaritiaShaders.COSMIC_UVS[i * 4 + 2] = sprite.m_118410_();
            AvaritiaShaders.COSMIC_UVS[i * 4 + 3] = sprite.m_118412_();
        }
        if (AvaritiaShaders.cosmicUVs != null) {
            AvaritiaShaders.cosmicUVs.m_5941_(AvaritiaShaders.COSMIC_UVS);
        }
        VertexConsumer cons = source.m_6299_(AvaritiaShaders.COSMIC_RENDER_TYPE);
        ArrayList<TextureAtlasSprite> atlasSprite = new ArrayList<TextureAtlasSprite>();
        for (ResourceLocation res : this.maskSprite) {
            atlasSprite.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(res));
        }
        mc.m_91291_().m_115162_(pStack, cons, CosmicBakeModel.bakeItem(atlasSprite), stack, light, overlay);
    }

    @Override
    @Nullable
    public PerspectiveModelState getModelState() {
        return (PerspectiveModelState)this.parentState;
    }

    @Override
    public boolean isCosmic() {
        return true;
    }
}

